
    list      p=16F628A           ; list directive to define processor
    #include <p16F628A.inc>       ; processor specific variable definitions
    errorlevel  -302              ; suppress message 302 from list file
    __CONFIG   _CP_OFF & _DATA_CP_OFF & _LVP_OFF & _BOREN_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _HS_OSC

INT_VAR       UDATA_SHR   
COPYB   RES   	1           ; temporary variable variable used FOR COPY OF PORTB
LASTCHR RES   	1           ; TEMPORARY VARIABLE KEEPS TABS ON LAS CHR SENT 0AAh=DOT 0EEh=DASH 
REG1	RES   	1
REG2    RES     1
wpm     RES		1			;wpm counter byte number of timer cycles (1mS)
twpm    RES		1			;this is the working count down register for timer 0 
SPEED	RES		1			;PORTA  SPEED SELECTION INPUTS BITS 0-3

;**********************************************************************
RESET_VECTOR  CODE    0x0000      ; processor reset vector
        	  goto   start      ; go to beginning of program
INT_VECTOR    CODE    0x0004      ; interrupt vector location
INTERRUPT
        	  retfie                    ; return from interrupt

MAIN_PROG    CODE    0X0020
;*******************************************************************************************
start
		MOVLW  00h
		MOVWF  LASTCHR		; THIS IS FIRST STEP AND SETS ALL THE VALUES IN THE SETUP REGISTERS 
		MOVLW  0x00			; AND INITIALISES THE LASTCHR VALUE TO INDICATE THAT NO PADDLES 
		MOVWF  0x03			; HAVE BEEN PRESSED BEFORE 
		MOVLW  0x05	;timer0	LASTCHR is for the iambic funtion ie if both paddles are pressed  
		MOVWF  0x01			;and the last charcter sent was a DOT then make this one a DASH 
		MOVLW  0x0EF 
		MOVWF  0x05	;porta
		MOVLW  0x0FF
		MOVWF  0x06	;portb
		MOVLW  0x00
		MOVWF  0x1F	;cmcon
		MOVLW  0x00
		MOVWF  0x0C	;pir1
		movlw  0x20		;switch to next bank
		movwf  0X03	;status
		movlw  0x0EF
		movwf  0X85	;trisa
		movlw  0x0FF
		movwf  0X86	;trisb
		movlw  0x00
		movwf  0X9f	;vrcon
		movlw  0x02
		movwf  0X81	;option
		movlw  0x00
		movwf  0X8c	;pie1
		movlw  0x00
		movwf  0x8e	;pcon
		movlw  0x00     ;switch back to 0 bank 
		movwf  0x03	;status
;***************************************************************************************
STARTA		
		BANKSEL PORTB 	;THIS SECTION IS THE START OF THE PROGRM PROPER 
		BTFSS 0x06,0	;AND CHECKS THE SPEED SELECTION SWITCHES 
		goto _20wpm		; PORTB RB0-RB3 BY BIT TEST INSTRUCTION 
		BTFSS 0x06,1	
		goto _19wpm		;NOTE THE TIMER DELAY IS 1mS AND THESE VALUS ARE FOR 
		BTFSS 0x06,2	; THE NUMBER OF 1mS COUNTED 
		goto _18wpm		; SPEED IS CALCULATED BY THE ARRL HANBOOKS 
		BTFSS 0x06,3	; FORMULA (WPM = 1.2 X CLOCK FREQ ) 
		goto _17wpm		; IE 12WPM = 1.2 X 10hz OR (WPM/1.2 = FREQ) (1/FREQ= TIME PERIOD) 
		BTFSS 0x06,6	; 1/10= 0.1 or 100mS
		goto _16wpm
		BTFSS 0x06,7
		goto _15wpm
		goto STARTA

_15wpm
		movlw 0x50			;80mS 
		movwf wpm
		movwf twpm
		goto PADDLE

_16wpm
		movlw 0x4B			;75mS
		movwf wpm
		movwf twpm
		goto PADDLE

_17wpm
		movlw 0x46			;70mS
		movwf wpm
		movwf twpm
		goto PADDLE

_18wpm
		movlw 0x42			;66mS
		movwf wpm
		movwf twpm
		goto PADDLE
_19wpm
		movlw 0x3F			;63mS
		movwf wpm
		movwf twpm
		goto PADDLE

_20wpm
		movlw 0x3C			;60mS
		movwf wpm
		movwf twpm
		goto PADDLE	

PADDLE					;SPEED HAS BEEN SET NOW POLLING TO SEE IF THE PADDLES ARE DOWN 
		BANKSEL PORTB	; WHICH ONES ARE 
		movf PORTB,0 	;potrb to w
		andlw 0x30		;and w with 30h so only test bits 4 and 5
		BTFSC STATUS,2	;test z bit of status to see if both paddles are down together  
		GOTO   BOTHDOWN
		btfss 0x06,5    ;test PORTB bit 5 and skip next instruction if set(clear or 0 = paddle down) 
		GOTO  DASH
		btfss 0x06,4 	;test PORTB bit 4 and skip next instruction if set(clear or 0 = paddle down) 
		GOTO  DOT
		GOTO   STARTA   ;if no paddles are down go back to the start and test speed switches again 
BOTHDOWN
		MOVF LASTCHR,0  ;if both paddles were down we now need to see what the last character sent was 
		XORLW 0x0ee		;and send the opposite 
		BTFSC STATUS,2	;CHECKS Z FLAG AFTER COMPARE (NOTE XOR IS A GREAT WAY TO COMPARE TWO BYTES
		GOTO LASTDASH	;IF THEY ARE THE SAME THE RESULT WILL BE ZERO )
		movf LASTCHR,0
		XORLW 0x0aa
		BTFSC STATUS,2  ;CHECKS Z FLAG AFTER COMPARE (NOTE XOR IS A GREAT WAY TO COMPARE TWO BYTES
		GOTO LASTDOT    ;IF THEY ARE THE SAME THE RESULT WILL BE ZERO )
		GOTO STARTA     ; BACK TO THE START AND WAIT TILL BOTH KEYS RELEASED AND ONE DOT OR DASH SENT
LASTDASH
		GOTO DOT
LASTDOT
		GOTO DASH		
;*******************************************************************************		
DASH
		BANKSEL LASTCHR
		MOVLW 0EEh
		MOVWF LASTCHR
		movlw 0x0ff
		movwf 0x05  	;PORTA BIT 4 (OUTPUT BIT ) SET HI
		MOVLW 0X0EF		;FOR THE OUTPUT TO BE PUT ON THE PIN YOU MUST SET THE PIN TO 0 (OUTPUT)
		BANKSEL TRISA   ;IN THE TRISA REG 
		MOVWF TRISA		;THE OUTPUT IS SET HI AND THEN THREE DOT TIMES ARE PASSED BEFORE IT 
		BANKSEL 0x00	;SET BACK TO LO , ONE DOT TIME IS PASSED BEFORE THE PADDLES ARE SAMPLED 
;******************this section times the output at 1 (pass 1) **********************
		
		movf wpm,0
		movwf twpm
		
timera7
		clrf 0x01
		clrf 0x0b
		MOVLW 0x05
		MOVWF 0x01
timer7		
		btfss 0x0b,2
		goto timer7		; USING INTERNAL TIMER SET TO 05 WITH PRESCALER ASSIGNED AND SET TO 8
		decfsz twpm,1	;set by the speed setting wpmXX value 	
		goto timera7	; NOTE the timer counts up and the flag is set on over flow
						; so if 05 is in the counter it will take 250 counts before overflow
;******************this section times the output at 1 (pass 2 )*********************************
		movf wpm,0
		movwf twpm
		
timera2
		clrf 0x01
		clrf 0x0b
		MOVLW 0x05
		MOVWF 0x01
timer2	
		btfss 0x0b,2
		goto timer2		; USING INTERNAL TIMER SET TO 05 WITH PRESCALER ASSIGNED AND SET TO 8 
		decfsz twpm,1	;set by the speed setting wpmXX value  	
		goto timera2	; NOTE the timer counts up and the flag is set on over flow
						; so if 05 is in the counter it will take 250 counts before overflow
		
;******************this section times the output at 1 ( pass 3 )*********************************
		movf wpm,0
		movwf twpm
		
timera3
		clrf 0x01
		clrf 0x0b
		MOVLW 0x05
		MOVWF 0x01
timer3		
		btfss 0x0b,2
		goto timer3		; USING INTERNAL TIMER SET TO FAh WITH PRESCALER ASSIGNED AND SET TO 8 
		decfsz twpm,1	;set by the speed setting wpmXX value  	
		goto timera3	; NOTE the timer counts up and the flag is set on over flow
		movf wpm,0		; so if 05 is in the counter it will take 250 counts before overflow
		movwf twpm
				
		MOVLW 0x0EF
		movwf 0x05  		;PORTA BIT 4 (OUTPUT BIT ) SET LO
		BANKSEL TRISA
		MOVWF TRISA   	;ACTUALLY PUTS OUTPUT TO PORT A PIN 
		BANKSEL PORTA  	;BACK TO BANK 0 
; *********************this output times the section at 0 ********************************

		movf wpm,0
		movwf twpm
		
timera4
		clrf 0x01
		clrf 0x0b
		MOVLW 0x05
		MOVWF 0x01
timer4		
		btfss 0x0b,2
		goto timer4		; USING INTERNAL TIMER SET TO 05h WITH PRESCALER ASSIGNED AND SET TO 8 
		decfsz twpm,1	;set by the speed setting wpmXX value  	
		goto timera4	; NOTE the timer counts up and the flag is set on over flow
		movf wpm,0		; so if 05 is in the counter it will take 250 counts before overflow	
		movwf twpm
		GOTO STARTA  ; dash has been sent now back to the start and check the paddles 

;***************************************************************************
DOT
		BANKSEL LASTCHR
		MOVLW 0AAh
		MOVWF LASTCHR
		movlw 0x0ff
		movwf 0x05  	;porta bit4 now set in the PORTA latch TRISA must be set  
		BANKSEL TRISA	;after PORTA to write the value to the IC pin 
		MOVWF TRISA
		BANKSEL PORTA
;******************this section times the output at 1 *********************************
		movf wpm,0
		movwf twpm
		
timera5
		clrf 0x01
		clrf 0x0b
		MOVLW 0x05
		MOVWF 0x01
timer5		
		btfss 0x0b,2
		goto timer5		; USING INTERNAL TIMER SET TO 05 WITH PRESCALER ASSIGNED AND SET TO 8  
		decfsz twpm,1	;set by the speed setting wpmXX value 	
		goto timera5	; NOTE the timer counts up and the flag is set on over flow 
						; so if 05 is in the counter it will take 250 counts before overflow
		banksel PORTA
		movlw 0x0ef
		movwf 0x05  	;porta bit4 now CLEARED
		BANKSEL TRISA	;TRISA must be set after PORTA to write the value to the IC pin
		MOVWF TRISA		;Note : a 0 set in TRISA will set PORTA as output and the value 
		BANKSEL PORTA   ;in the PORTA latch will be sent to the IC pin 

	
; *********************this output times the section at 0 ********************************		
		movf wpm,0
		movwf twpm
		
timera6
		clrf 0x01
		clrf 0x0b
		MOVLW 0x05
		MOVWF 0x01
timer6		
		btfss 0x0b,2
		goto timer6		; USING INTERNAL TIMER SET TO 05 WITH PRESCALER ASSIGNED AND SET TO 8
		decfsz twpm,1	;set by the speed setting wpmXX value  	
		goto timera6	; NOTE the timer counts up and the flag is set on over flow 
						; so if 05 is in the counter it will take 250 counts before overflow 
		GOTO STARTA  ; dot has been sent now back to the start and check the paddles 
        END                       ; directive 'end of program'
